/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;

public class PHPSearchEngine {
    public static Result<?, ?> find(String path, String currentWorkingDir, String currentScriptDir, IProject currentProject) {
        Object[] includePaths;
        if (path == null || currentWorkingDir == null || currentScriptDir == null || currentProject == null) {
            throw new NullPointerException("Parameters can't be null");
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(file);
        }
        if (path.matches("\\.\\.?[/\\\\].*")) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(currentWorkingDir, path);
        }
        Object[] objectArray = includePaths = PHPSearchEngine.buildIncludePath(currentProject);
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object includePath = objectArray[n2];
            if (includePath instanceof IContainer) {
                IContainer container = (IContainer)includePath;
                IResource resource = container.findMember(path);
                if (resource instanceof IFile) {
                    return new ResourceResult((IFile)resource);
                }
            } else if (includePath instanceof IIncludePathEntry) {
                IResource resource;
                IProject project;
                File entryDir;
                IIncludePathEntry entry = (IIncludePathEntry)includePath;
                IPath entryPath = entry.getPath();
                if (entry.getEntryKind() == 1) {
                    if (entry.getContentKind() != 2 && (file = new File(entryDir = entryPath.toFile(), path)).exists()) {
                        return new IncludedFileResult(entry, file);
                    }
                } else if (entry.getEntryKind() == 4) {
                    entryPath = IncludePathVariableManager.instance().resolveVariablePath(entryPath.toString());
                    entryDir = entryPath.toFile();
                    file = new File(entryDir, path);
                    if (file.exists()) {
                        return new IncludedFileResult(entry, file);
                    }
                } else if (entry.getEntryKind() == 2 && (project = (IProject)entry.getResource()).isAccessible() && (resource = project.findMember(path)) instanceof IFile) {
                    return new ResourceResult((IFile)resource);
                }
            }
            ++n2;
        }
        return PHPSearchEngine.searchExternalOrWorkspaceFile(currentScriptDir, path);
    }

    private static Result<?, ?> searchExternalOrWorkspaceFile(String directory, String relativeFile) {
        IContainer container;
        IResource file;
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(directory);
        if (resource instanceof IContainer && (file = (container = (IContainer)resource).findMember(relativeFile)) instanceof IFile) {
            return new ResourceResult((IFile)file);
        }
        File dir = new File(directory);
        if (dir.isDirectory()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(new File(dir, relativeFile));
        }
        return null;
    }

    private static Result<?, ?> searchExternalOrWorkspaceFile(File file) {
        if (file.exists()) {
            IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            if (res != null) {
                return new ResourceResult(res);
            }
            if (file.exists()) {
                return new ExternalFileResult(file);
            }
        }
        return null;
    }

    public static Object[] buildIncludePath(IProject project) {
        HashSet<Object> results = new HashSet<Object>();
        PHPSearchEngine.buildIncludePath(project, results);
        return results.toArray();
    }

    public static void buildIncludePath(IProject project, Set<Object> results) {
        int n;
        int n2;
        IIncludePathEntry[] iIncludePathEntryArray;
        if (results.contains(project)) {
            return;
        }
        if (!project.isAccessible() || !project.isOpen()) {
            return;
        }
        PHPProjectOptions projectOptions = PHPProjectOptions.forProject((IProject)project);
        if (projectOptions != null) {
            IIncludePathEntry[] includePath;
            iIncludePathEntryArray = includePath = projectOptions.readRawIncludePath();
            n2 = includePath.length;
            n = 0;
            while (n < n2) {
                IIncludePathEntry entry = iIncludePathEntryArray[n];
                if (entry.getEntryKind() != 2) {
                    results.add(entry);
                }
                ++n;
            }
        }
        try {
            IProject[] referencedProjects = project.getReferencedProjects();
            iIncludePathEntryArray = referencedProjects;
            n2 = referencedProjects.length;
            n = 0;
            while (n < n2) {
                IIncludePathEntry referencedProject = iIncludePathEntryArray[n];
                PHPSearchEngine.buildIncludePath((IProject)referencedProject, results);
                ++n;
            }
        }
        catch (CoreException coreException) {}
        results.add(project);
    }

    public static class ExternalFileResult
    extends Result<Object, File> {
        public ExternalFileResult(File file) {
            super(file.getParentFile(), file);
        }
    }

    public static class IncludedFileResult
    extends Result<IIncludePathEntry, File> {
        public IncludedFileResult(IIncludePathEntry container, File file) {
            super(container, file);
        }
    }

    public static class ResourceResult
    extends Result<Object, IFile> {
        public ResourceResult(IFile file) {
            super(file.getParent(), file);
        }
    }

    public static abstract class Result<T, S> {
        private T container;
        private S file;

        public Result(T container, S file) {
            this.container = container;
            this.file = file;
        }

        public T getContainer() {
            return this.container;
        }

        public S getFile() {
            return this.file;
        }
    }
}

